#include <ATcrt/ATsystem.h>
#include "Handler.h"
#include "Aerotri_defs.h"
struct strTrabajoAerotri;
typedef struct strTrabajoAerotri TrabajoAerotri;

//In the subsequent functions a return value of 0 means it executed correctly
#ifdef __cplusplus
extern "C"{
#endif

TrabajoAerotri* get_trabajo_aerotri(void);	//Retrives one and sets the pointers to NULL
void ATtrabajos_free(void *p);	//Frees a pointer: if(p!=NULL) free(p);
void libera_trabajoAT(TrabajoAerotri *p);	//Pointers within this struct that are not NULL are freed.
					//If you haven't modified the struct on your own, you don't have to care about this.
					//The struct itself is not freed. You have to free it with ATtrabajos_free(p)

/*lee_trabajoAT returns either 0 or ATREAD_NOOPEN
escribe_trabajoAT may return 0 or
	AT_NOMEM
	1 ... 4: The file could not be opened for writing, for whatever reason.
	>4: An error while writing. The file is likely incomplete or wrong.

In calcula_trabajoAT, the parameter allow_empty instructs the function to allow missing values of
precisions (precision of the image coordintes, of control points, etc. )
*/
int lee_trabajoAT(const char16_t* ficherot, TrabajoAerotri *trabajo);
int escribe_trabajoAT(const char16_t* ficherot, TrabajoAerotri *trabajo, bint modo);
int calcula_trabajoAT(Handler hwnd_main, int log_code, TrabajoAerotri *tr, bint allow_empty, char16_t* mensaje, u8int idioma);
#ifdef __cplusplus
}
#endif

/*In order to compute a work from a file write a function like compute_from_file() in maintest.c 

The function calcula_trabajo_aerotri() returns
	0: Cálculo terminado correctamente
	<0: Un error general, común a todas la funciones. De momento solo puede ser
		AT_ESC,
		AT_NOMEM,
		-10:	Error desconocido
	0<nret<500:			El error devuelto por prepara_trabajo_relativa (v. infra)
	500<nret<1000:		500 + el error devuelto por prepara_trabajo_absoluta (v. infra)
	1000<nret<2000:	1000+ el error devuelto por calcula_relativa (v. mainrelativa.h)
	2000<nret<3000:	2000+ el error devuelto por calcula_absoluta (v. infra)

if(nret>1000) mensaje stores the error message, that can be displayed.
Therefore you may not need to ever look at the meaning of the error codes returned from
calcula_relativa and calcula_abosluta.

* hwnd_main is a handler of a Windows window and
* log_code a user message code (i.e., above WM_USER). They are used to send
progress messages to the caller in the form

		SendMessage(hwnd_main,log_code,0,(LPARAM)progress_message);

which is done by the block adjustment function from time to time.
Therefore, the value passed to calcula_trabajo_aerotri as log_code is the one
the caller (you) want to receibe as message code.

progress_message is of type const char16_t*.
If hwnd_main is null it is ignored and the above calls are not performed.

* mensaje must be of type char16_t[512] or NULL.
* idioma specifies the language of the message returned in mensaje well as that
   of progress messages send to the window hwnd_main.
*/

//Codes returned by prepara_trabajo_relativa
enum ATPreparaRelativaCodes{
	ATPreparaRel_OK=0,
	ATPreparaRel_ficherof_null,	//No se ha indicado fichero de fotogramas
	ATPreparaRel_ficherof_invalidchar,	//Incluye algún carácter no válido para un nombre de fichero
	ATPreparaRel_ficherof_ftm,		//La extensión es ".ftm" pero el tipo de fichero es !=2
	ATPreparaRel_ficherof_noint,	//El tipo de fichero es >=3 y no se ha indicado fichero de cámara
	ATPreparaRel_ficheroint_invalidchar,	//en el fichero de cámara
	ATPreparaRel_ficherogps_invalidchar,	//en el fichero de gps/ins
	ATPreparaRel_precf_null,		//Falta el valor de precisión de las fotocoordenadas
	ATPreparaRel_precf_invalidchar,	//No tiene el formato de un número
	ATPreparaRel_precf_zero,			//el valor es cero
	ATPreparaRel_precf_negative,		//el valor es negativo
};

//Codes returned by prepara_trabajo_absoluta
enum ATPreparaAbsolutaCodes{
	ATPreparaAbs_OK=0,
	ATPreparaAbs_ficherof_null,		//No se ha indicado fichero de fotogramas
	ATPreparaAbs_ficherof_invalidchar,		//Incluye algún carácter no válido para un nombre de fichero
	ATPreparaAbs_ficherof_ftm,		//La extensión es ".ftm" pero el tipo de fichero es !=2
	ATPreparaAbs_ficherof_noint,		//El tipo de fichero es >=3 y no se ha indicado fichero de cámara
	ATPreparaAbs_ficheroint_invalidchar,	//en el fichero de orientación cámara
	ATPreparaAbs_ficheroapr_null,		//No se ha indicado fichero de valores aproximados
	ATPreparaAbs_ficheroapr_invalidchar,	//en el fichero de valores aproximados
	ATPreparaAbs_ficheroapy_invalidchar,	//en el fichero de apoyo
	ATPreparaAbs_ficherogps_invalidchar,	//en el fichero de gps/ins
	ATPreparaAbs_precf_null,		//Falta el valor de precisión de las fotocoordenadas
	ATPreparaAbs_precf_invalidchar,	//No tiene el formato de un número
	ATPreparaAbs_precf_zero,			//el valor es cero
	ATPreparaAbs_precf_negative,		//el valor es negativo
	ATPreparaAbs_precpXY_null,		//Falta el valor de precisión planimétrica del apoyo (si hay fich. de apoyo)
	ATPreparaAbs_precpXY_invalidchar,	//No tiene el formato de un número
	ATPreparaAbs_precpXY_zero,			//el valor es cero
	ATPreparaAbs_precpXY_negative,		//el valor es negativo
	ATPreparaAbs_precpZ_null,			//Falta el valor de precisión atimétrica del apoyo
	ATPreparaAbs_precpZ_invalidchar,	//No tiene el formato de un número
	ATPreparaAbs_precpZ_zero,				//el valor es cero
	ATPreparaAbs_precpZ_negative,		//el valor es negativo
	ATPreparaAbs_precgpsXY_null,	//Falta el valor de precisión planimétrica del gps (si hay fich. de gps)
	ATPreparaAbs_precgpsXY_invalidchar, //No tiene el formato de un número
	ATPreparaAbs_precgpsXY_zero,		//el valor es cero
	ATPreparaAbs_precgpsXY_negative,	//el valor es negativo
	ATPreparaAbs_precgpsZ_null,		//Falta el valor de precisión atimétrica del apoyo
	ATPreparaAbs_precgpsZ_invalidchar,	//No tiene el formato de un número
	ATPreparaAbs_precgpsZ_zero,			//el valor es cero
	ATPreparaAbs_precgpsZ_negative,		//el valor es negativo
	ATPreparaAbs_precinsWF_null,	//Falta el valor de precisión de inclinaciones del INS (si hay fich. de gps)
	ATPreparaAbs_precinsWF_invalidchar, //No tiene el formato de un número
	ATPreparaAbs_precinsWF_zero,		//el valor es cero
	ATPreparaAbs_precinsWF_negative,	//el valor es negativo
	ATPreparaAbs_precinsK_null,		//Falta el valor de precisión de giro Kappa del INS
	ATPreparaAbs_precinsK_invalidchar,	//No tiene el formato de un número
	ATPreparaAbs_precinsK_zero,			//el valor es cero
	ATPreparaAbs_precinsK_negative,		//el valor es negativo
};

/* The above functions are enough for reading and writing a 'trabajo' from a file
and asking the API to compute it. This computation consists of two steps.

1st. If the trabajo does not include an approximate values file these must be
	computed, wherefore calcula_trabajo_aerotri() calls these two functions:
			prepara_trabajo_relativa()
			calcula_trabajo_relativa()
	The successful computation of approximate values results in a file named
	like the photographs file but with extension .prm.
	It trabajo already specifies an approximate values file this step is omitted.

2nd. The block adjustment is performed, and to that end calcula_trabajo_aerotri()
	calls these two functions
			prepara_trabajo_absoluta()
			calcula_trabajo_absoluta()

	The same approximate values file can be used for several block adjustments,
	provided no new points are measured.

In order to be able to call the individual functions, the definitions below
are needed.

If the filename extension of the photographs file is three or less characters long
the approximate values file generated from calcula_trabajo_relativa() will be
like that with the extension replaced by prm. Otherwise, if the extension is
four or more characters long or if the filename has no extension, the extension
.prm will be appended.
*/

#include <ATcrt/ATmem.h>	//requires ATcrt.lib
#include <ATcrt/ATfileoutput.h>	//only needed because of the Bufferto8* from calcula_absoluta
#include <ATsistemas/ClaseSistema.h>
#include "ClasesGPS.h"
#include "mainrelativa.h"	//requires relativa.lib
#define sinline static inline
#include "clases_mainabsoluta.h"
struct strRelativaParams;
struct strAbsolutaCallData;
#define APARAMS_flags0_Semilibre 1

#ifdef __cplusplus
extern "C"{
#endif
struct strRelativaParams* get_relativa_params(void);		//The structs strRelativaParams and
struct strAbsolutaCallData* get_absoluta_calldata(void);	//strAbsolutaCallData do not have
													//pointers to reserved memory that need to be freed.
int prepara_trabajo_relativa(const TrabajoAerotri *trabajo, struct strRelativaParams *pparams);
int prepara_trabajo_absoluta(const TrabajoAerotri *trabajo, struct strAbsolutaCallData *pparams, bint allow_empty);
void change_absparams(struct strAbsolutaCallData *params,uint kind,uintptr_t valor);	//see the documentation
int calcula_relativa(Handler hwnd_main,int log_code, const struct strRelativaParams *params, InfoMalos *pinfomalos,char16_t *mensaje, u8int idioma);
int calcula_absoluta(Handler hwnd_main,int log_code,Bufferto8 *log_file, const struct strAbsolutaCallData *params, FicheroBnf *pinfo,char16_t *mensaje, u8int idioma);
#ifdef __cplusplus
}
#endif
/* The possible return values of prepara_trabajo_relativa and prepara_trabajo_absoluta are declared above.
The return values of calcula_relativa are specified at mainrelativa.h. These codes are the same as for the
function mainrelativa(). You are not intended to call this function directly, although you can. If so note
that mensaje cannot be NULL for this function. The different return values for prepara_trabajo_absoluta
can be found at the end of the file clases_mainabsoluta.h. */

/*The following file defines the struct TrabajoAerotri. It is not needed for the use of this API's functions.
It is provided so that the struct can be modified by the caller, typically upon action of the user on a graphic
user interface. This can also be achieved by writing the .art file according to the modifications performed
and reading it with lee_trabajoAT(). This way the callers of this API can have their own struct representing
a user's 'trabajo' which maps to a plain text .art file, which is then read by this API filling an AerotriTrabajo
structure, which need not be known by the caller.
In those cases comment out this line. */
#include "ClaseTrabajo.h"
